<?php

	use DOMHelper\DOMHelper;
	use System\Deprecated;
	use System\Themes;

	/**
	 * This was originally an all-encompassing class for a bunch of off-hand utility methods in the CMS prior
	 * to major version 4. However, it is now just a compatibility layer.
	 * @deprecated
	 */
	#[Deprecated]
	class CMSInternals{

		/**
		 * Returns the final H3 match in a string
		 * @param ?string $html
		 * @return string
		 */
		public static function getLastH3(?string $html): string{
			return DOMHelper::getLastH3($html);
		}

		/**
		 * Removes the final H3 from html
		 * This functions accepts the HTML as a reference and modifies the original variable
		 * @param string &$html (reference)
		 * @return void
		 */
		public static function deleteLastH3(string &$html): void{
			DOMHelper::deleteLastH3($html);
		}

		public static function getFirstH1(string $html): string{
			return DOMHelper::getFirstH1($html);
		}

		public static function deleteFirstH1(string &$html): void{
			DOMHelper::deleteFirstH1($html);
		}

		/**
		 * Parses the string to XML and attempts to add classes to it
		 * This function expects to only parse a single element
		 * @param string $html
		 * @param string[] $classes
		 * @return string
		 */
		public static function addClassesToElement(string $html, array $classes): string {
			if (!empty($html)) {
				libxml_use_internal_errors(true);
				$dom = new DOMDocument('1.0', 'UTF-8');
				$dom->preserveWhiteSpace = false;
				$dom->formatOutput = false;

				$dom->loadHTML(
					source: '<!DOCTYPE html><html><body>' . $html . '</body></html>',
					options: LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD
				);

				// Get the first element node inside <body>
				$element = $dom->getElementsByTagName('body')->item(0)->firstChild;
				while ($element && $element->nodeType !== XML_ELEMENT_NODE) {
					$element = $element->nextSibling;
				}

				if ($element instanceof DOMElement) {
					$currentClasses = preg_split('/\s+/', $element->getAttribute("class"), -1, PREG_SPLIT_NO_EMPTY);
					$currentClasses = array_unique(array_merge($currentClasses, $classes));
					$element->setAttribute("class", implode(" ", $currentClasses));
					return $dom->saveHTML($element);
				}
			}

			return "";
		}

		public static function getCurrentThemeURI(): string{
			return Themes::getCurrentThemeDirectoryURI();
		}
	}
