<?php
	namespace Crons\Timers;

	require_once __DIR__ . "/Timer.php";

	class IntervalTimer extends Timer {
		public int $everyXSeconds = 0;
		public int $everyXMinutes = 0;
		public int $everyXHours = 0;
		public int $everyXDays = 0;
		public int $everyXMonths = 0;

		public function getDueTimestamp(int $lastRunTimestamp): int
		{
			$totalIncrementInSeconds = $this->everyXSeconds
				+ ($this->everyXMinutes * 60)
				+ ($this->everyXHours * 3600)
				+ ($this->everyXDays * 86400)
				+ ($this->everyXMonths * 2.628e6);

			return $lastRunTimestamp + $totalIncrementInSeconds;
		}
	}