<?php
	namespace DOMHelper;

	use DOMDocument;

	class DOMHelper{
		/**
		 * Returns the final H3 match in a string
		 *
		 * @param string $html
		 * @return string
		 */
		public static function getLastH3(string $html): string{
			preg_match_all("/<\s*h3.*?>.+?<\s*\/\s*h3\s*>/ism", $html, $matches);
			if (!empty($matches)){
				if (isset($matches[0]) && isset($matches[0][count($matches[0]) - 1])){
					return $matches[0][count($matches[0]) - 1];
				}
			}

			return "";
		}

		/**
		 * Returns the first H1 match in a string
		 *
		 * @param string $html
		 * @return string
		 */
		public static function getFirstH1(string $html): string{
			preg_match_all("/<\s*h1.*?>.+?<\s*\/\s*h1\s*>/ism", $html, $matches);
			if (!empty($matches)){
				if (isset($matches[0]) && isset($matches[0][0])){
					return $matches[0][0];
				}
			}

			return "";
		}

		/**
		 * Removes the final H3 from html
		 *
		 * This functions accepts the HTML as a reference and modifies the original variable
		 *
		 * @param string $html (reference)
		 * @return void
		 */
		public static function deleteLastH3(string &$html): void{
			$lastH3 = self::getLastH3($html);
			$html = str_replace($lastH3, "", $html);
		}

		/**
		 * Removes the first H1 from html
		 *
		 * This functions accepts the HTML as a reference and modifies the original variable
		 *
		 * @param string $html (reference)
		 * @return void
		 */
		public static function deleteFirstH1(string &$html): void{
			$firstH1 = self::getFirstH1($html);
			$html = str_replace($firstH1, "", $html);
		}
	}