<?php

	namespace FileSystemUtilities;

	class FSFile
	{

		public string $fileExtension;
		public string $fileNameWithoutExtension;

		public function __construct(
			public string $fileName,
			public string $fullFilePath,
			public int    $fileSize,
		)
		{
			$this->fileExtension = pathinfo($this->fullFilePath, PATHINFO_EXTENSION);
			$this->fileNameWithoutExtension = pathinfo($this->fullFilePath, PATHINFO_FILENAME);
		}
	}