<?php
	namespace FindAndReplace\Dtos;

	use FindAndReplace\FindResultItem;
	use Page\Page;

	class FoundPageDto{
		/**
		 * @var bool If the page has layout sections
		 */
		public bool $isSectioned = false;
		/** @var bool If the page does not have layout sections and the pageBody matched the query */
		public bool $pageBodyMatched = false;
		/** @var bool If the pageHead matched the query. This is agnostic to page sectioning */
		public bool $pageHeadMatched = false;
		/**
		 * @var FoundPageSectionMatchDto[] If the page is sectioned, this will be non-empty if
		 * any layout sections matched the query
		 * */
		public array $sectionMatches = [];
		/** @var Page The page object itself */
		public Page $page;
		/** @var FindResultItem[] Only populated if the pageHeadMatched is true */
		public array $pageHeadFindResultItems = [];
		/** @var FindResultItem[] Only populated if the pageBodyMatched is true */
		public array $pageBodyFindResultItems = [];

		public static function fromArray(array $a): FoundPageDto{
			$obj = new FoundPageDto();
			$obj->isSectioned = $a["isSectioned"];
			$obj->pageBodyMatched = $a["pageBodyMatched"];
			$obj->pageHeadMatched = $a["pageHeadMatched"];
			$obj->sectionMatches = array_map(fn ($subArray) => FoundPageSectionMatchDto::fromArray($subArray), $a["sectionMatches"]);
			$obj->page = Page::fromArray($a["page"]);
			$obj->pageBodyFindResultItems = array_map(fn ($subArray) => FindResultItem::fromArray($subArray), $a["pageBodyFindResultItems"]);
			$obj->pageHeadFindResultItems = array_map(fn ($subArray) => FindResultItem::fromArray($subArray), $a["pageHeadFindResultItems"]);
			return $obj;
		}
	}