<?php

	namespace ImageGallery;

	use Nox\ORM\ColumnQuery;
	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	class ImageGallery extends ModelClass implements ModelInstance
	{

		public ?int $id = null;
		public string $name;
		public int $creationTime;

		/** @var int|null This is no modeled, but can be filled manually */
		public ?int $numImagesInGallery = null;

		public static function getModel(): MySQLModelInterface
		{
			return new ImageGalleryModel();
		}

		public function __construct()
		{
			parent::__construct($this);
		}

		/**
		 * Fetches the number of images in this gallery, will also populate the value for
		 * the numImagesInGallery property of this object.
		 * @return int
		 */
		public function fetchNumImagesInGallery(): int
		{
			$numMembers = ImageGalleryMember::count(
				columnQuery: (new ColumnQuery())
					->where("gallery_id", "=", $this->id),
			);
			$this->numImagesInGallery = $numMembers;
			return $numMembers;
		}

		/**
		 * Generates a gallery name that is safe to place into a shortcode attribute value surrounded by quotations.
		 */
		public function getShortcodeAttributeSafeGalleryName(): string{
			$buffer = "";
			foreach(str_split($this->name) as $char){
				if ($char === " " || $char === "_" || $char === "-"){
					$buffer .= "-";
				}else{
					// Check if alpha-numeric
					$didMatch = preg_match("/[a-z0-9]/i", $char);
					if ($didMatch === 1) {
						$buffer .= $char;
					}
				}
			}

			$buffer = trim($buffer);

			// Replace more than two dashes as one dash
			$buffer = preg_replace("/-{2,}/", "-", $buffer);

			return $buffer;
		}
	}