<?php

	namespace ImageGallery;

	enum ImageGallerySortBy: string{
		case POSITION = "position";
		case TIMESTAMP = "timestamp";

		public static function getByValue(
			string $value
		): ?ImageGallerySortBy{
			foreach(self::cases() as $case) {
				if($case->value === strtolower($value)) {
					return $case;
				}
			}
			return null;
		}
	}