<?php

	namespace ImageGallery;

	enum ImageGallerySortDirection: string{
		case ASCENDING = "asc";
		case DESCENDING = "desc";

		public static function getByValue(
			string $value
		): ImageGallerySortDirection{
			foreach(self::cases() as $case) {
				if($case->value === strtolower($value)) {
					return $case;
				}
			}
		}
	}