<?php
	namespace MonologWrapper;

	use Monolog\Handler\RotatingFileHandler;
	use Monolog\Level;
	use Monolog\Logger;
	use Monolog\Handler\StreamHandler;

	class MonologWrapper{

		const LOG_LOCATION = __DIR__ . "/../../../uplift-data/logs/internal-log.log";
		const LOG_LEVEL = Level::Debug;
		const MAX_DAYS_OF_LOG_RETENTION = 30;
		private static Logger $logger;
		private static Logger $stdOutLogger;

		public static function createLogDirectoryIfNotExists(): void{
			$logDirectory = dirname(self::LOG_LOCATION);
			if (!file_exists($logDirectory)){
				@mkdir(
					directory: $logDirectory,
					recursive: true
				);
			}
		}

		public static function getLogger(): Logger{
			self::createLogDirectoryIfNotExists();

			if (!isset(self::$logger)){
				self::$logger = new Logger("Uplift");
				self::$logger->pushHandler(
					new RotatingFileHandler(self::LOG_LOCATION,self::MAX_DAYS_OF_LOG_RETENTION, self::LOG_LEVEL, true, 0664)
				);
			}

			return self::$logger;
		}

		public static function getLoggerWithSTDOutStream(): Logger{
			self::createLogDirectoryIfNotExists();

			if (!isset(self::$stdOutLogger)){
				self::$stdOutLogger = new Logger("Uplift");
				self::$stdOutLogger->pushHandler(
					new StreamHandler(STDOUT,self::LOG_LEVEL)
				);
			}

			return self::$stdOutLogger;
		}
	}