<?php

	namespace Page\PageAttributes;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;

	#[Model]
	class PageAttributePageTypeModel implements MySQLModelInterface
	{

		private string $mysqlDatabaseName = \NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = \NoxEnv::MYSQL_TABLE_NAME_PREFIX . "page_attribute_page_type";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = PageAttributePageType::class;

		public function getDatabaseName(): string
		{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "page_attribute_id",
					classPropertyName: "pageAttributeID",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "page_type",
					classPropertyName: "pageType",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
			];
		}
	}
