<?php

	namespace Page;

	use JsonSerializable;
	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	class PageBreadcrumb extends ModelClass implements ModelInstance, JsonSerializable
	{

		public ?int $id = null;
		public int $pageID;
		public int $position;
		public string $label;
		public string $uri;

		/**
		 * Converts the object to JSON
		 */
		public function jsonSerialize(): array
		{
			return [
				"pageID" => $this->pageID,
				"position" => $this->position,
				"label" => $this->label,
				"uri" => $this->uri,
			];
		}

		public static function getModel(): MySQLModelInterface
		{
			return new PagesBreadcrumbsModel();
		}

		public function __construct()
		{
			parent::__construct($this);
		}
	}