<?php

	namespace Page;
	enum PageType
	{
		case Service;
		case General;
		case Project;
		case City;
		case Blog;

		public static function has(string $enumName): bool{
			foreach(self::cases() as $case){
				if ($case->name === $enumName){
					return true;
				}
			}

			return false;
		}

		public static function fromName(string $enumName): ?PageType{
			foreach(self::cases() as $case){
				if ($case->name === $enumName){
					return $case;
				}
			}

			return null;
		}
	}