<?php

	namespace PageArchives;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\MediumText;
	use Nox\ORM\MySQLDataTypes\Text;
	use Nox\ORM\MySQLDataTypes\TinyInteger;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class PageArchivesModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "pages_edit_archives";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = PageArchive::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "page_id",
					classPropertyName: "pageID",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "archived_timestamp",
					classPropertyName: "archivedTimestamp",
					dataType: new Integer(),
					defaultValue: time(),
				),
				new ColumnDefinition(
					name: "pageName",
					classPropertyName: "pageName",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "pageType",
					classPropertyName: "pageType",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "pageRoute",
					classPropertyName: "pageRoute",
					dataType: new VariableCharacter(255),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "pageRouteIsRegex",
					classPropertyName: "pageRouteIsRegex",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "pageLayout",
					classPropertyName: "pageLayout",
					dataType: new VariableCharacter(255),
					defaultValue: "",
					isNull: false,
				),
				new ColumnDefinition(
					name: "pageHead",
					classPropertyName: "pageHead",
					dataType: new Text(),
					defaultValue: "",
					isNull: false,
				),
				new ColumnDefinition(
					name: "pageBody",
					classPropertyName: "pageBody",
					dataType: new MediumText(),
					defaultValue: "",
					isNull: false,
				),
				new ColumnDefinition(
					name: "creationTime",
					classPropertyName: "creationTime",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "excludeFromSitemap",
					classPropertyName: "excludeFromSitemap",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "excludeSchemaInjection",
					classPropertyName: "excludeSchemaInjection",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "publication_status",
					classPropertyName: "publicationStatus",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "publication_timestamp",
					classPropertyName: "publicationTimestamp",
					dataType: new Integer(),
					defaultValue: 0,
				),
			];
		}
	}
