<?php
	namespace PageRestoration;

	use Nox\ORM\Abyss;
	use Nox\ORM\ColumnQuery;
	use Nox\ORM\Pager;
	use Nox\ORM\ResultOrder;
	use Page\Page;
	use PageArchives\PageArchive;
	use PageArchives\PageArchivesModel;
	use Uplift\Exceptions\NoObjectFound;

	class PageRestorationService{
		/**
		 * @param int $pageNumber
		 * @param string $query
		 * @return array{pages: Page[], totalPages: int}
		 */
		public static function queryDeletedPages(
			int $pageNumber,
			string $query,
			int $limit = 25,
		): array{
			$query = trim($query);

			$abyss = new Abyss();
			$connection = $abyss->getConnectionToDatabase(\NoxEnv::MYSQL_DB_NAME);

			$queryAndClause = "";
			if (!empty($query)){
				$queryAndClause = sprintf("AND `pageName` LIKE \"%%%s%%\"", $connection->escape_string($query));
			}

			$offset = ($pageNumber - 1) * $limit;
			$statement = $connection->prepare(sprintf("
				SELECT * FROM `%s`
				WHERE page_id NOT IN (
				    SELECT id FROM `%s`
				) %s
				GROUP BY page_id
				LIMIT $limit
				OFFSET $offset
			",
				\NoxEnv::MYSQL_TABLE_NAME_PREFIX . "pages_edit_archives",
				\NoxEnv::MYSQL_TABLE_NAME_PREFIX . "pages",
				$queryAndClause
			));

			$statement->execute();
			$result = $statement->get_result();

			$statementNoLimit = $connection->prepare(sprintf("
				SELECT * FROM `%s`
				WHERE page_id NOT IN (
				    SELECT id FROM `%s`
				) %s
				GROUP BY page_id
			",
				\NoxEnv::MYSQL_TABLE_NAME_PREFIX . "pages_edit_archives",
				\NoxEnv::MYSQL_TABLE_NAME_PREFIX . "pages",
				$queryAndClause
			));

			$statementNoLimit->execute();
			$resultNoLimit = $statementNoLimit->get_result();
			$totalRows = $resultNoLimit->num_rows;

			$pageArchives = [];
			foreach($result->fetch_all(MYSQLI_ASSOC) as $row){
				$pageArchives[] = $abyss->instanceFromModel(new PageArchivesModel, $row);
			}

			return [
				"pageArchives"=>$pageArchives,
				"totalPages"=>ceil($totalRows / $limit),
			];
		}

		/**
		 * @throws NoObjectFound
		 */
		public static function restorePageFromArchive(
			int $archiveID
		): void{
			/** @var PageArchive $archive */
			$archive = PageArchive::fetch($archiveID);

			if ($archive === null){
				throw new NoObjectFound("No page archive with ID $archiveID");
			}

			$page = new Page();
			$page->id = $archive->pageID;
			$page->pageType = $archive->pageType;
			$page->pageName = $archive->pageName;
			$page->pageBody = $archive->pageBody;
			$page->pageHead = $archive->pageHead;
			$page->pageLayout = $archive->pageLayout;
			$page->creationTime = $archive->creationTime;
			$page->pageRouteIsRegex = $archive->pageRouteIsRegex;
			$page->excludeFromSitemap = $archive->excludeFromSitemap;
			$page->publicationTimestamp = $archive->publicationTimestamp;
			$page->publicationStatus = $archive->publicationStatus;
			$page->save();
		}
	}