<?php

	namespace Redirects;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\Text;
	use Nox\ORM\MySQLDataTypes\TinyInteger;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class RedirectsModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "redirects";


		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = Redirect::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "from_uri",
					classPropertyName: "fromURI",
					dataType: new Text(),
				),
				new ColumnDefinition(
					name: "to",
					classPropertyName: "to",
					dataType: new VariableCharacter(2024),
					defaultValue: "",
				),
				new ColumnDefinition(
					name: "is_regex",
					classPropertyName: "isRegEx",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "preserve_query_string",
					classPropertyName: "preserveQueryString",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "status_code",
					classPropertyName: "statusCode",
					dataType: new Integer(3),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "added_timestamp",
					classPropertyName: "addedTimestamp",
					dataType: new Integer(),
					defaultValue: time(),
				),
			];
		}
	}
