<?php

	use Accounts\Account;
	use Accounts\AccountsService;
	use Nox\Http\Redirect;
	use Nox\ORM\ColumnQuery;
	use Nox\RenderEngine\Renderer;
	use Nox\Router\Attributes\Controller;
	use Nox\Router\Attributes\Route;
	use Nox\Router\BaseController;
	use Settings\RequireSettingValue;
	use Settings\Setting;
	use Settings\Settings;
	use System\System;

	#[Controller]
	class RootController extends BaseController
	{

		#[Route("GET", "/admin-panel")]
		public function loginView(): Redirect|string
		{
			$account = Account::getCurrentUser();
			if ($account === null) {
				return Renderer::renderView("login/main.php");
			} else {
				return new Redirect("/uplift/dashboard");
			}
		}

		#[Route("GET", "/ipp-form")]
		#[RequireSettingValue(Settings::IPP_FORM_DISABLED, ["0", null])]
		public function ippFormRedirect(): Redirect
		{
			$account = Account::getCurrentUser();
			if ($account === null) {
				return new Redirect("/admin-panel?to=/uplift/ipp-form");
			} else {
				return new Redirect("/uplift/ipp-form");
			}
		}

		#[Route("GET", "/missing-nox-env-file")]
		public function missingNoxEnvFile(): Redirect|string
		{
			http_response_code(503);
			return Renderer::renderView("errors/missing-nox-env-file.html");
		}

		#[Route("GET", "/invalid-database-credentials")]
		public function invalidDatabaseCredentials(): Redirect|string
		{
			http_response_code(503);
			return Renderer::renderView("errors/invalid-db-credentials.html");
		}

		#[Route("GET", "/bad-api-key")]
		public function badAPIKeyView(): Redirect|string
		{
			http_response_code(403);
			return Renderer::renderView("errors/bad-api-key.html");
		}

		#[Route("GET", "/missing-api-key")]
		public function missingAPIKeyView(): Redirect|string
		{
			http_response_code(403);
			return Renderer::renderView("errors/missing-api-key.html");
		}

		#[Route("GET", "/system-missing-api-key")]
		public function systemMissingAPIKey(): Redirect|string
		{
			http_response_code(403);
			return Renderer::renderView("errors/system-missing-api-key.html");
		}

		#[Route("GET", "/uplift/logout")]
		public function logoutCurrentUser(): Redirect
		{
			AccountsService::logoutCurrentSession();
			return new Redirect(
				path:"/admin-panel",
				statusCode: 302,
			);
		}

		#[Route("GET", "/robots.txt")]
		#[Route("HEAD", "/robots.txt")]
		public function robotsView(): string
		{
			/** @var Setting $robots */
			$robots = Setting::queryOne(
				columnQuery: (new ColumnQuery())
					->where("name", "=", "robots"),
			);

			if ($robots === null){
				$robotsValue = "";
			}else{
				$robotsValue = $robots->value;
			}

			header('Content-Type: text/plain; charset=utf-8');
			header("Content-Length: " . strlen($robotsValue));

			if (BaseController::$noxInstance->router->requestMethod === "head"){
				return "";
			}else {
				return $robotsValue;
			}
		}

		#[Route("GET", "/uplift/version")]
		public function upliftVersion(): string
		{
			return System::VERSION;
		}
	}