<?php
	namespace Settings;

	use Attribute;
	use Nox\Router\AttributeResponse;
	use Nox\Router\Interfaces\RouteAttribute;

	// Tell the attribute it can only be used on class methods
	#[Attribute(Attribute::TARGET_METHOD)]
	class RequireSettingValue implements RouteAttribute{

		public function __construct(
			public Settings $setting,
			public array $acceptedValues,
		){}

		public function getAttributeResponse(): AttributeResponse
		{
			$settingValue = Setting::getSettingValue($this->setting->value);

			if (in_array($settingValue, $this->acceptedValues)){
				return new AttributeResponse(
					isRouteUsable: true,
				);
			}else{
				return new AttributeResponse(
					isRouteUsable: false,
				);
			}
		}
	}