<?php
	namespace Settings;

	use Nox\ORM\ColumnQuery;

	class CustomSettingService{
		/**
		 * Fetches all CustomSetting rows with a name $customSetting
		 * and returns their CustomSetting instances as an array. Array will be blank if none exist.
		 * @param CustomSettings $customSetting
		 * @return CustomSetting[]
		 */
		public static function getAllCustomSettings(CustomSettings $customSetting): array{
			/** @var CustomSetting[] $customSettings */
			$customSettings = CustomSetting::query(
				columnQuery: (new ColumnQuery())
					->where("name", "=", $customSetting->name)
			);

			return $customSettings;
		}

		public static function clearAllCustomSettingsOfType(CustomSettings $customSetting): void{
			/** @var CustomSetting[] $customSettings */
			$customSettings = CustomSetting::query(
				columnQuery: (new ColumnQuery())
					->where("name", "=", $customSetting->name)
			);

			foreach($customSettings as $customSettingInstance){
				$customSettingInstance->delete();
			}
		}
	}