<?php
	namespace Settings;

	use Nox\ORM\Interfaces\ModelInstance;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\ModelClass;

	class Setting extends ModelClass implements ModelInstance{

		const SETTING_NAMES = [
			"theme_name"=>"theme_name",
			"schemaType"=>"schemaType",
			"companyName"=>"companyName",
			"companyStreet"=>"companyStreet",
			"companyCity"=>"companyCity",
			"companyState"=>"companyState",
			"companyPostal"=>"companyPostalCode",
			"companyLogo"=>"companyLogo",
			"companyFavicon"=>"companyFavicon",
			"companyPhoneNumbers"=>"companyPhoneNumbers",
			"companyFaxNumbers"=>"companyFaxNumbers",
			"thumbnailUploadSizeX"=>"thumbnailUploadSizeX",
			"thumbnailUploadSizeY"=>"thumbnailUploadSizeY",
			"enablePushNotifications"=>"enablePushNotifications",
			"forceHTTPs"=>"forceHTTPs",
			"noindex"=>"noindex",
			"noReviewsMessage"=>"no-reviews-message",
			"instanceID"=>"instanceID",
			"core_needs_updating"=>"core_needs_updating",
			"robots"=>"robots",
		];

		public ?string $name = null;
		public ?string $value;

		/**
		 * Fetches the value of a setting, if that setting exists.
		 */
		public static function getSettingValue(string $settingName): string | null{
			return self::fetch(
				primaryKey: $settingName,
			)?->value ?? null;
		}

		/**
		 * Fetches the value of a setting identified by the enum, if that setting exists.
		 */
		public static function getSettingValueIdentifiedByEnum(Settings $settingEnum): string | null{
			return self::fetch(
				primaryKey: $settingEnum->value,
			)?->value ?? null;
		}

		public static function getModel(): MySQLModelInterface{
			return new SettingsModel();
		}

		public function __construct()
		{
			parent::__construct($this);
		}

	}