<?php
	namespace ShortcodeParser\Processors;

	require_once __DIR__ . "/Processor.php";

	use Page\Page;
	use Page\PageDatas;
	use Settings\Setting;
	use Settings\Settings;
	use ShortcodeParser\Processors\Exceptions\NoPageCurrentlyRendered;
	use ShortcodeParser\Shortcode;
	use ShortcodeParser\ShortcodeTypes;

	/**
	 * Processor class for the company-name shortcode
	 */
	class GetCompanyName extends Processor {

		protected static array $supportedAttributes = [];

		public static function getSupportedAttributeNames(): array{
			return self::$supportedAttributes;
		}

		public function __construct(
			public Shortcode $shortcode
		){}

		public function runProcessor(): string{
			$settingValue = Setting::getSettingValue(Settings::COMPANY_NAME->value);
			return $settingValue !== null ? $settingValue : "";
		}
	}
