<?php
	namespace ShortcodeParser\Processors;

	require_once __DIR__ . "/Processor.php";

	use Exception;
	use NoxEnv;
	use ShortcodeParser\Shortcode;

	/**
	 * Processor class for the map-key shortcode
	 */
	class GetGoogleMapsAPIKey extends Processor {

		protected static array $supportedAttributes = [];

		public static function getSupportedAttributeNames(): array{
			return self::$supportedAttributes;
		}

		public function __construct(
			public Shortcode $shortcode
		){}

		/**
		 * @throws Exception
		 */
		public function runProcessor(): string{
			return NoxEnv::GOOGLE_MAPS_API_KEY;
		}
	}
