<?php

	namespace ShortcodeParser\Processors;

	use Exception;
	use Page\Page;
	use ShortcodeParser\Processors\Exceptions\InvalidAttributeValue;
	use ShortcodeParser\Processors\Exceptions\MissingRequiredAttribute;
	use ShortcodeParser\Processors\Exceptions\NoPageCurrentlyRendered;
	use ShortcodeParser\Shortcode;
	use ShortcodeParser\ShortcodeTypes;
	use Uplift\Exceptions\NoObjectFound;

	class GetPageAttributePageValue extends Processor {

		protected static array $supportedAttributes = [
			"id",
		];

		public static function getSupportedAttributeNames(): array{
			return self::$supportedAttributes;
		}

		public function __construct(
			public Shortcode $shortcode
		){}

		/**
		 * @throws MissingRequiredAttribute
		 * @throws Exception
		 */
		public function runProcessor(): string
		{
			$idAttribute = $this->shortcode->getAttribute("id");

			// required id attribute
			if ($idAttribute === null){
				throw new MissingRequiredAttribute(
					sprintf(
						"Attribute 'id' is required in %s",
						ShortcodeTypes::GET_PAGE_ATTRIBUTE_VALUE->value,
					)
				);
			}

			// Fetch the page attribute page value
			$currentPage = Page::getCurrentPage();
			if ($currentPage === null){
				throw new NoPageCurrentlyRendered(
					sprintf(
						"The shortcode %s is required to be rendered on a page. Page::getCurrentPage() must be set to a Page object.",
						ShortcodeTypes::GET_PAGE_ATTRIBUTE_VALUE->value,
					),
				);
			}

			try {
				$pageAttributePageValue = $currentPage->getAttributeValue($idAttribute->value);
			}catch(NoObjectFound $e){
				throw new InvalidAttributeValue(
					sprintf(
						"Failure in shortcode %s: %s",
						ShortcodeTypes::GET_PAGE_ATTRIBUTE_VALUE->value,
						$e->getMessage(),
					),
				);
			}

			return $pageAttributePageValue->value;
		}
	}