<?php
	namespace ShortcodeParser\Processors;

	require_once __DIR__ . "/Processor.php";

	use Exception;
	use Nox\ORM\ColumnQuery;
	use Nox\ORM\Pager;
	use Nox\ORM\ResultOrder;
	use Page\Page;
	use Page\PageData;
	use Page\PageDatas;
	use Page\PageType;
	use Page\PublicationStatus;
	use ShortcodeParser\Processors\Exceptions\InvalidAttributeValue;
	use ShortcodeParser\Processors\Exceptions\MissingRequiredAttribute;
	use ShortcodeParser\Processors\Exceptions\ShortcodeViewFileNotFound;
	use ShortcodeParser\Shortcode;
	use ShortcodeParser\ShortcodeTypes;
	use System\ContentHelper;
	use System\Themes;

	/**
	 * Processor class for the get-articles shortcode
	 */
	class IncludeFile extends Processor {

		protected static array $supportedAttributes = [
			"file",
		];

		public static function getSupportedAttributeNames(): array{
			return self::$supportedAttributes;
		}

		public function __construct(
			public Shortcode $shortcode
		){}

		/**
		 * @throws MissingRequiredAttribute
		 * @throws InvalidAttributeValue
		 * @throws Exception
		 */
		public function runProcessor(): string{

			// Required attribute
			$fileAttribute = $this->shortcode->getAttribute("file");
			if ($fileAttribute === null){
				throw new MissingRequiredAttribute(
					sprintf(
						"Attribute 'file' is required in %s",
						ShortcodeTypes::INCLUDE_FILE->value,
					)
				);
			}else{
				$includeFilePath = $fileAttribute->value;
			}

			// Includes folder
			$includesFolder = Themes::getCurrentThemeIncludesDirectory();

			// Get the view file and then its contents
			$includedFilePath = sprintf("%s/%s", $includesFolder, $includeFilePath);
			$includedNormalizedFilePath = realpath($includedFilePath);
			if ($includedNormalizedFilePath === false){
				throw new ShortcodeViewFileNotFound(
					sprintf("No includes file found at the following path: %s", $includedFilePath),
				);
			}

			// Begin output buffering
			ob_start();

			// Include the file
			include($includedNormalizedFilePath);

			// Get the contents in the current buffer
			$contents = ob_get_contents();

			// End and empty the current buffer
			ob_end_clean();

			return $contents;
		}
	}
