<?php
	namespace ShortcodeParser\Processors;

	require_once __DIR__ . "/Processor.php";

	use Exception;
	use ShortcodeParser\Shortcode;
	use System\HttpHelper;

	/**
	 * Processor class for the get-articles shortcode
	 */
	class URL extends Processor {

		protected static array $supportedAttributes = [];

		public static function getSupportedAttributeNames(): array{
			return self::$supportedAttributes;
		}

		public function __construct(
			public Shortcode $shortcode
		){}

		/**
		 * @throws Exception
		 */
		public function runProcessor(): string{
			return HttpHelper::getWebsiteBaseURL() . HttpHelper::getURI();
		}
	}
