<?php
	namespace System;

	class PhoneNumberUtility{
		public static function getPurePhoneNumber(string $phoneNumber): string{

			// Variable to hold the byte-by-byte number buffer
			$numberBuffer = "";

			foreach (str_split($phoneNumber) as $char){
				// Force-lower the character
				$char = strtolower($char);
				$decimalRep = ord($char);

				if ($decimalRep >= 97 && $decimalRep <= 99){
					$numberBuffer .= "2";
				}elseif ($decimalRep >= 100 && $decimalRep <= 102){
					$numberBuffer .= "3";
				}elseif ($decimalRep >= 103 && $decimalRep <= 105){
					$numberBuffer .= "4";
				}elseif ($decimalRep >= 106 && $decimalRep <= 108){
					$numberBuffer .= "5";
				}elseif ($decimalRep >= 109 && $decimalRep <= 111){
					$numberBuffer .= "6";
				}elseif ($decimalRep >= 112 && $decimalRep <= 115){
					$numberBuffer .= "7";
				}elseif ($decimalRep >= 116 && $decimalRep <= 118){
					$numberBuffer .= "8";
				}elseif ($decimalRep >= 119 && $decimalRep <= 122){
					$numberBuffer .= "9";
				}else{
					// Is the remaining character a number or + symbol?
					if ($char === "+" || ctype_digit($char) === true){
						$numberBuffer .= $char;
					}
				}
			}

			return $numberBuffer;
		}
	}