<?php

	namespace System\Updater\SystemBuildInformation;

	use GuzzleHttp\Client;
	use GuzzleHttp\Exception\GuzzleException;
	use GuzzleHttp\RequestOptions;
	use MonologWrapper\MonologWrapper;
	use Settings\Setting;
	use Settings\Settings;
	use System\HttpHelper;
	use System\System;
	use Uplift\Exceptions\MalformedValue;

	class SystemBuildInformationService{

		public static function sendUpdatedBuildInformationToControlPanel(): void{
			$logger = MonologWrapper::getLogger();
			$logger->info("Submitting build info to master control panel.");
			$client = new Client();
			$host = System::getUpliftControlPanelHost();
			$endpoint = sprintf("%s/uplift/build/update-build-info", $host);
			$method = "PATCH";
			$uuid = Setting::getSettingValue(Settings::BUILD_UUID->value);
			$apiKey = Setting::getSettingValue(Settings::UPLIFT_CONTROL_PANEL_API_KEY->value);

			try {
				 $response = $client->request(
					method: $method,
					uri: $endpoint,
					options: [
						RequestOptions::HEADERS => [
							"Uplift-UUID" => $uuid,
							"Uplift-API-Key" => $apiKey,
						],
						RequestOptions::MULTIPART => [
							[
								"name" => "acceloCompanyID",
								"contents" => Setting::getSettingValue(Settings::ACCELO_COMPANY_ID->value) ?? "",
							],
							[
								"name" => "companyName",
								"contents" => Setting::getSettingValue(Settings::COMPANY_NAME->value) ?? "",
							],
							[
								"name" => "serverIP",
								"contents" => $_SERVER['SERVER_ADDR'],
							],
							[
								"name" => "website",
								"contents" => HttpHelper::getWebsiteBaseURL(),
							],
							[
								"name" => "indexingDisabled",
								"contents" => Setting::getSettingValue(Settings::ENTIRE_SITE_NO_INDEX->value) ?? "0",
							],
							[
								"name" => "version",
								"contents" => System::VERSION,
							],
							[
								"name" => "isTestBuild",
								"contents" => Setting::getSettingValue(Settings::IS_TEST_BUILD->value) ?? "",
							],
							[
								"name" => "isSuspended",
								"contents" => Setting::getSettingValue(Settings::SITE_SUSPENDED->value) ?? "",
							],
						],
					],
				);

				 $logger->info("Successful response from control panel was: " . $response->getBody()->getContents());
			} catch (GuzzleException $e) {
				$logger->error("Failed sending info to master control panel. Exception from GuzzleHttp is: {$e->getMessage()}");
			}
		}

	}