<?php

	namespace System\Updater\PostUpdate;

	use Settings\Setting;
	use Settings\Settings;
	use Settings\SettingService;
	use System\Themes;

	/**
	 * This post update process handles when injectable settings need to be automatically handled by some
	 * custom logic.
	 */
	final class AutoOptOutInjectables extends PostUpdateProcess{
		public function runProcess(): void
		{
			// For the Lightbox injectable, only auto-opt out after an update if the following are met
			// - The setting does not exist at all
			// - AND the default theme location has a directory /js/lightbox
			$currentOptOutLightboxSetting = Setting::getSettingValue(Settings::OPT_OUT_LIGHTBOX_INJECTION->value);
			if ($currentOptOutLightboxSetting === null){
				// Check for a lightbox directory
				$currentThemeDirectory = Themes::getCurrentThemeDirectory();
				$lightboxDirectory = $currentThemeDirectory . "/js/lightbox";
				if (file_exists($lightboxDirectory)){
					// File exists, opt out of the injected lightbox
					SettingService::saveSetting(
						name: Settings::OPT_OUT_LIGHTBOX_INJECTION->value,
						value:"1",
					);
				}
			}

		}
	}