<?php

	namespace TemplateManager\PageLayouts;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\MediumText;
	use Nox\ORM\MySQLDataTypes\TinyInteger;
	use Nox\ORM\MySQLDataTypes\VariableCharacter;
	use NoxEnv;

	#[Model]
	class PageLayoutSectionModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "page_layout_sections";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = PageLayoutSection::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "page_layout_section_definition_id",
					classPropertyName: "pageLayoutSectionDefinitionId",
					dataType: new Integer(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "section_name",
					classPropertyName: "sectionName",
					dataType: new VariableCharacter(700),
				),
				new ColumnDefinition(
					name: "is_default_content_section",
					classPropertyName: "isDefaultContentSection",
					dataType: new TinyInteger(),
					defaultValue: 0,
				),
				new ColumnDefinition(
					name: "creation_timestamp",
					classPropertyName: "creationTimestamp",
					dataType: new Integer(),
					defaultValue: time(),
				),
			];
		}
	}
