<?php

	namespace TemplateManager\PageLayouts;

	use Nox\ORM\Attributes\Model;
	use Nox\ORM\ColumnDefinition;
	use Nox\ORM\Interfaces\MySQLModelInterface;
	use Nox\ORM\MySQLDataTypes\Integer;
	use Nox\ORM\MySQLDataTypes\Text;
	use NoxEnv;

	#[Model]
	class PageLayoutSectionsDefinitionModel implements MySQLModelInterface
	{

		/**
		 * The name of the database this table belongs to
		 */
		private string $mysqlDatabaseName = NoxEnv::MYSQL_DB_NAME;

		/**
		 * The name of this Model in the MySQL database as a table
		 */
		private string $mysqlTableName = NoxEnv::MYSQL_TABLE_NAME_PREFIX . "page_layout_section_definitions";

		/**
		 * The string name of the class this model represents and can instantiate
		 */
		private string $representingClassName = PageLayoutSectionsDefinition::class;

		public function getDatabaseName(): string{
			return $this->mysqlDatabaseName;
		}

		public function getName(): string
		{
			return $this->mysqlTableName;
		}

		public function getInstanceName(): string
		{
			return $this->representingClassName;
		}

		public function getColumns(): array
		{
			return [
				new ColumnDefinition(
					name: "id",
					classPropertyName: "id",
					dataType: new Integer(),
					defaultValue: 0,
					autoIncrement: true,
					isPrimary: true,
					isNull: false,
				),
				new ColumnDefinition(
					name: "layout_file_name",
					classPropertyName: "layoutFileName",
					dataType: new Text(),
					isNull: true,
				),
				new ColumnDefinition(
					name: "creation_timestamp",
					classPropertyName: "creationTimestamp",
					dataType: new Integer(),
					defaultValue: time(),
				),
			];
		}
	}
