<?php

	use Nox\Http\JSON\JSONError;
	use Nox\Http\JSON\JSONResult;
	use Nox\Http\JSON\JSONSuccess;

	class ThemeImporterService {

		/**
		 * @param string $url
		 * @return string
		 */
		public static function downloadFile(
			string $url
		): string
		{
			// Sets the directory for our themes
			$themeDirectory = "../uplift-data/themes/";

			// Sets the name of the theme file being downloaded
			$fileName = basename($url);

			// Adds the time to the file name, to ensure we don't overwrite an existing zip file
			$uniqueFileName = pathinfo($fileName, PATHINFO_FILENAME) . '_' . time() . '.' . pathinfo($fileName, PATHINFO_EXTENSION);

			// Sets the directory + file name for our upload
			$saveTo = $themeDirectory . $uniqueFileName;

			// Downloads the theme
			$fileContent = file_get_contents($url);

			// Places the theme in the set directory
			file_put_contents($saveTo, $fileContent);

			// returns the directory + file name
			return $saveTo;
		}

		/**
		 * @param string $file
		 * @param string $overwrite
		 * @return JSONResult
		 */
		public static function extractAndDeleteFile(
			string $file,
			string $overwrite
		): JSONResult
		{
			// Gets the directory of the file to extract
			$extractTo = dirname($file) . '/';

			// Creates a new ZipArchive
			$zip = new ZipArchive;

			// Open the ZipArchive
			if ($zip->open($file) !== true) {
				return new JSONError("Could not find file - please report this to an administrator.");
			}

			// If not allowed to overwrite, check for existing files
			if ($overwrite !== "true") {
				for ($i = 0; $i < $zip->numFiles; $i++) {
					if (file_exists($extractTo . $zip->getNameIndex($i))) {
						// Close the archive
						$zip->close();

						// Delete the zip file
						unlink($file);

						return new JSONError("Unable to overwrite - a file with this name already exists.");
					}
				}
			}

			// Extract the files and close the archive
			$zip->extractTo($extractTo);
			$zip->close();

			// Delete the zip file
			unlink($file);

			return new JSONSuccess([]);
		}
	}