<?php
	namespace Uplift\Vite;

	use App\Vite\ViteResource;
	use NoxEnv;

	class ViteStaticService{
		private static bool $HasInjectedVite = false;

		/**
		 * Returns script or link HTML elements for Vite resources. If the environment is in development,
		 * then the Vite client will be injected as well.
		 * @param ViteResource[] $resources
		 * @return string
		 */
		public static function Use(array $resources): string{
			if (\NoxEnv::DEV_ENV === "development"){
				$viteHost = NoxEnv::VITE_DEVELOPMENT_HOST;
				$buffer = "";

				if (!self::$HasInjectedVite){
					$buffer .= "<script type=\"module\" src=\"$viteHost/@vite/client\"></script>\n";
					self::$HasInjectedVite = true;
				}

				foreach ($resources as $resource)
				{
					$extension = pathinfo($resource->devResourcePath, PATHINFO_EXTENSION);
					if ($extension === "ts" || $extension === "js")
					{
						$buffer .= "<script type=\"module\" src=\"{$viteHost}{$resource->devResourcePath}\"></script>\n";
					}
					else if ($extension === "css" || $extension === "scss")
					{
						$buffer .= "<link rel=\"stylesheet\" href=\"{$viteHost}{$resource->devResourcePath}\">\n";
					}
				}

				return $buffer;
			}else{
				$buffer = "";
				$buildOutputDirectory = __DIR__ . "/../../resources/static/build/assets";
				$frontEndUrlRootPath = "/uplift-assets/build/assets";
				foreach ($resources as $resource)
				{
					$filesInDirectory = array_diff(scandir($buildOutputDirectory), ['..', '.']);
					$extension = pathinfo($resource->devResourcePath, PATHINFO_EXTENSION);
					if ($extension === "ts" || $extension === "js")
					{
						foreach($filesInDirectory as $fileName){
							if (str_starts_with($fileName, $resource->bundleResourceInputName . "-") && str_ends_with($fileName, ".js")){
								$buffer .= "<script type=\"module\" src=\"{$frontEndUrlRootPath}/{$fileName}\"></script>\n";
							}
						}
					}
					else if ($extension === "css" || $extension === "scss")
					{
						foreach($filesInDirectory as $fileName){
							if (str_starts_with($fileName, $resource->bundleResourceInputName . "-") && str_ends_with($fileName, ".css")){
								$buffer .= "<link rel=\"stylesheet\" href=\"{$frontEndUrlRootPath}/{$fileName}\">\n";
							}
						}
					}
				}

				return $buffer;
			}
		}
	}