<?php
	// Get all of the projects in our database
	$projects = Page\Page::query(
		columnQuery: (new Nox\ORM\ColumnQuery())
			->where("pageType","=","Project")
			->and()
			->where("publication_status","=",1)
	);
	
	$parser = new ShortcodeParser\ShortcodeParser();
	$lexicalParser = new ShortcodeParser\ShortcodeLexicalParser();
	$shortcode = $lexicalParser->getShortcodeFromString('{{ get-recent-projects num-projects="3" columns="3" shortcode-file="recent-projects-custom.php" included-project-tags="[]" autofill="0" }}');
	
	// If there are any projects, display them. Otherwise, append a coming soon notice
	if($projects) {
		echo $parser->processShortcode($shortcode);
	} else {
		?>
		<p class="text-center">
			Coming soon!
		</p>
		<?php
	}
?>