<?php
	/** @var string $bodyContents */
	/** @var string $headContents */
	/** @var string $breadcrumbs */
	/** @var string $schemaType */
    $h3 = CMSInternals::getLastH3($bodyContents);
    CMSInternals::deleteLastH3($bodyContents);	
?>
<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/<?= $schemaType; ?>">
	<head>
		<?php include(__DIR__  . "/../includes/meta.php"); ?>
		<?= $headContents; ?>
	</head>
	<body>
		<?php include(__DIR__ . "/../includes/navigation.php"); ?>
		<main id="content">
			<div class="bg-white">
				<div class="container-fluid">
					<section class="row py-xl-5" id="general">
						<div class="col-xl-9 col-lg-10 col-12 mx-auto p-3 p-lg-5">
							<?= $breadcrumbs; ?>
							<?= $bodyContents; ?>
						</div>
					</section>
					<?php include(__DIR__ . "/../includes/cta.php"); ?>
				</div>
			</div>	
		</main>
		<?php include(__DIR__ . "/../includes/footer.php"); ?>
	</body>
</html>
