<?php
	/** @var mixed $schemaType */
	/** @var mixed $headContents */
	/** @var mixed $bodyContents */
	/** @var mixed $breadcrumbs */

	/** @var mixed $featuredImage */
	/** @var mixed $featuredImageThumb */
	/** @var mixed $cityName */
	/** @var mixed $stateName */
	/** @var mixed $stateNameShorthand */
	/** @var mixed $brandProducts */
	/** @var mixed $customerFirstName */
	/** @var mixed $customerLastName */
	/** @var mixed $customerTestimonialBody */
	/** @var mixed $customerTestimonialCheck */
	/** @var mixed $mapKey */

	// Gets the H1, assigns it to the $h1 variable, and removes it from the page
	$h1Regex = "/<h1.*?>(.+?)<\/h1>/ism";
	preg_match($h1Regex, $bodyContents, $h1Matches);
	$bodyContents = preg_replace($h1Regex, "", $bodyContents, 1);
	$h1 = $h1Matches[1];
    $h3 = CMSInternals::getLastH3($bodyContents);
    CMSInternals::deleteLastH3($bodyContents);	

	// Sets the date that the article was published
	$publishDate;
	if($this->publicationTimestamp !== 0) {
		$publishDate = date("F j, Y", $this->publicationTimestamp);
	} else {
		$publishDate = date("F j, Y", $this->creationTime);
	}
?>
<!DOCTYPE html>
<html lang="en" itemscope itemtype="https://schema.org/<?= $schemaType; ?>">
	<head>
		<?php include(__DIR__  . "/../includes/meta.php"); ?>
		<?= $headContents; ?>
	</head>
	<body>
		<?php include(__DIR__ . "/../includes/navigation.php"); ?>
		<main id="content">
			<div class="bg-white">
				<div class="container-fluid">
					<section class="row py-xl-5" id="project">
						<div class="col-xl-9 col-lg-10 col-12 mx-auto p-3 p-lg-5">
							<?= $breadcrumbs; ?>
							<h1><?= $h1; ?></h1>
							<p>
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-clock" viewBox="0 0 16 16">
									<path d="M8 3.5a.5.5 0 0 0-1 0V9a.5.5 0 0 0 .252.434l3.5 2a.5.5 0 0 0 .496-.868L8 8.71z"/>
									<path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m7-8A7 7 0 1 1 1 8a7 7 0 0 1 14 0"/>
								</svg>
								<?= $publishDate; ?>
							</p>
							<div class="clearfix">
								<?= $bodyContents; ?>
							</div>
							<?php
								if (trim($brandProducts) != ""){
									?>
									<h2 class="">Products Used</h2>
									<?= $brandProducts; ?>
									<?php
								}
							?>
							<?php
								if ($customerTestimonialCheck == 1){
									?>
									<h2 class="">Client Review</h2>
									
									<div class="{{ COLUMN_CLASS }} pb-4">
										<div class="bg-white border-left-primary border-top-primary shadow-primary-right rounded-3 p-4 mb-3 h-100 d-flex flex-column">
											<p><?= $customerTestimonialBody; ?></p>
											<p class="testimonial-author-data mt-auto">
											<?php
												if (!empty(trim($customerFirstName))){
													?>
													- <i class="fas fa-comment"></i> <span class="testimonial-name"><?= $customerFirstName; ?> <?= $customerLastName; ?></span> |
													<?php
												}
											?>
												
												<svg fill="gold" width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-star-fill" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
													<path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
												</svg>
												<svg fill="gold" width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-star-fill" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
													<path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
												</svg>
												<svg fill="gold" width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-star-fill" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
													<path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
												</svg>
												<svg fill="gold" width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-star-fill" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
													<path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
												</svg>
												<svg fill="gold" width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-star-fill" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
													<path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
												</svg>
											</p>
										</div>
									</div>
									
									<p>
										
									</p>
									
									<?php
								}
							?>
							<?php
								if (trim($cityName) != ""){
									?>
									<div class="ratio ratio-21x9 mb-3">
										<iframe src="https://www.google.com/maps/embed/v1/place?key=<?= $mapKey ?>&q=<?= preg_replace("/[\s]/i", "+", $cityName); ?>+<?= preg_replace("/[\s]/i", "+", $stateName); ?>"></iframe>
									</div>
									<?php
								}
							?>
						</div>
					</section>
					<?php include(__DIR__ . "/../includes/cta.php"); ?>
				</div>
			</div>
		</main>
		<?php include(__DIR__ . "/../includes/footer.php"); ?>
	</body>
</html>